import { Link } from "react-router-dom";


export const Navigation = () => {
  return (
     <div className="min-h-screen flex items-center justify-center p-5 bg-while-to-br from-indigo-500 to-while-600">
      <div className="flex flex-wrap  gap-5 justify-center w-full max-w-5xl">
         {/* Daily Submission Section */}
         <Link
          to="/dashboard"
          className="flex-1 min-w-[300px] min-h-[200px] p-5 rounded-2xl bg-white/20 backdrop-blur-md border border-white/30 shadow-xl flex flex-col items-center justify-center text-center transition-transform duration-300 ease-in-out hover:-translate-y-1 hover:shadow-2xl"
          style={{ background: "red" }}
        >
          <div className="text-4xl mb-3">📝</div>
          <h2 className="text-white text-xl font-semibold mb-2">Daily Submission</h2>
          <p className="text-white/90">Submit your daily work updates and tasks.</p>
        </Link>
        
        {/* Report Section */}
        <Link
          to="/report"
          className="flex-1 min-w-[300px] min-h-[200px] p-5 rounded-2xl bg-white/20 backdrop-blur-md border border-white/30 shadow-xl flex flex-col items-center justify-center text-center transition-transform duration-300 ease-in-out hover:-translate-y-1 hover:shadow-2xl"
          style={{ background: "red" }}
        >
          <div className="text-4xl mb-3">📊</div>
          <h2 className="text-white text-xl font-semibold mb-2">Report Section</h2>
          <p className="text-white/90">Summary of your daily reports and statistics.</p>
        </Link>

       
      </div>
    </div>
  )
}
